/*

  Macro_Scripts File
Purposes:  
    
	define action for each creatable Shape object to hook up to the create main menu (or quads)


Revision History
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	Nov 17 1999: Frank Delise
	created
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

----------------------------------------------------------
macroScript Lines 
            category:~LINES_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~LINES_TOOLTIP~ 
            buttontext:~LINES_BUTTONTEXT~ 
            Icon:#("Splines",1)
(
   on execute do StartObjectCreation Line
   on isChecked return (mcrUtils.IsCreating Line)
)
----------------------------------------------------------
macroScript Circle 
            category:~CIRCLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~CIRCLE_TOOLTIP~ 
            buttontext:~CIRCLE_BUTTONTEXT~ 
            Icon:#("Splines",2)
(
   on execute do StartObjectCreation Circle 
   on isChecked return (mcrUtils.IsCreating Circle)
)
----------------------------------------------------------
macroScript Arc 
            category:~ARC_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ARC_TOOLTIP~ 
            buttontext:~ARC_BUTTONTEXT~ 
            Icon:#("Splines",3)
(
   on execute do StartObjectCreation Arc
   on isChecked return (mcrUtils.IsCreating Arc)
)
----------------------------------------------------------
macroScript Ngon 
            category:~NGON_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~NGON_TOOLTIP~ 
            buttontext:~NGON_BUTTONTEXT~ 
            Icon:#("Splines",4)
(
   on execute do StartObjectCreation Ngon
   on isChecked return (mcrUtils.IsCreating Ngon)
)
----------------------------------------------------------
macroScript Text 
            category:~TEXT_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~TEXT_TOOLTIP~ 
            buttontext:~TEXT_BUTTONTEXT~ 
            Icon:#("Splines",5)
(
   on execute do StartObjectCreation Text 
   on isChecked return (mcrUtils.IsCreating Text)
)
----------------------------------------------------------
macroScript Rectangle 
            category:~RECTANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~RECTANGLE_TOOLTIP~ 
            buttontext:~RECTANGLE_BUTTONTEXT~ 
            Icon:#("Splines",7)
(
   on execute do StartObjectCreation Rectangle 
   on isChecked return (mcrUtils.IsCreating Rectangle)
)
----------------------------------------------------------
macroScript Ellipse 
            category:~ELLIPSE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ELLIPSE_TOOLTIP~ 
            buttontext:~ELLIPSE_BUTTONTEXT~ 
            Icon:#("Splines",8)
(
   on execute do StartObjectCreation Ellipse 	
   on isChecked return (mcrUtils.IsCreating Ellipse)
)
----------------------------------------------------------
macroScript Donut 
            category:~DONUT_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~DONUT_TOOLTIP~ 
            buttontext:~DONUT_BUTTONTEXT~ 
            Icon:#("Splines",9)
(
   on execute do StartObjectCreation Donut 
   on isChecked return (mcrUtils.IsCreating Donut)
)
----------------------------------------------------------
macroScript Star 
            category:~STAR_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STAR_TOOLTIP~ 
            buttontext:~STAR_BUTTONTEXT~ 
            Icon:#("Splines",10)
(
   on execute do StartObjectCreation Star 
   on isChecked return (mcrUtils.IsCreating Star)
)
----------------------------------------------------------
macroScript Helix 
            category:~HELIX_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~HELIX_TOOLTIP~ 
            buttontext:~HELIX_BUTTONTEXT~ 
            Icon:#("Splines",11)
(
   on execute do StartObjectCreation Helix 
   on isChecked return (mcrUtils.IsCreating Helix)
)

----------------------------------------------------------
macroScript Section 
            category:~SECTION_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~SECTION_TOOLTIP~ 
            buttontext:~SECTION_BUTTONTEXT~ 
            Icon:#("Splines",6)
(
   on execute do StartObjectCreation Section 
   on isChecked return (mcrUtils.IsCreating Section)
)

----------------------------------------------------------
macroScript Egg 
            category:~EGG_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~EGG_TOOLTIP~ 
            buttontext:~EGG_BUTTONTEXT~ 
            Icon:#("Splines",9)
(
   on execute do StartObjectCreation Egg 
   on isChecked return (mcrUtils.IsCreating Egg)
)

----------------------------------------------------------
macroScript WRectangle
            category:~WRECTANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~WRECTANGLE_TOOLTIP~ 
            buttontext:~WRECTANGLE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation WalledRectangle
   on isChecked return (mcrUtils.IsCreating WalledRectangle)
)

----------------------------------------------------------
macroScript Angle
            category:~ANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ANGLE_TOOLTIP~ 
            buttontext:~ANGLE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Angle
   on isChecked return (mcrUtils.IsCreating Angle)
)

----------------------------------------------------------
macroScript WideFlange
            category:~WIDEFLANGE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~WIDEFLANGE_TOOLTIP~ 
            buttontext:~WIDEFLANGE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation WideFlange
   on isChecked return (mcrUtils.IsCreating WideFlange)
)

----------------------------------------------------------
macroScript Channel
            category:~CHANNEL_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~CHANNEL_TOOLTIP~ 
            buttontext:~CHANNEL_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Channel
   on isChecked return (mcrUtils.IsCreating Channel)
)

----------------------------------------------------------
macroScript Tee
            category:~TEE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~TEE_TOOLTIP~ 
            buttontext:~TEE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Tee
   on isChecked return (mcrUtils.IsCreating Tee)
)

----------------------------------------------------------
macroScript StartNewShapeLock
            category:~STARTNEWSHAPELOCK_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STARTNEWSHAPELOCK_TOOLTIP~
            ButtonText:~STARTNEWSHAPELOCK_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try
		(
			if maxOps.startNewShapeLock == true then 
			(
				maxOps.startNewShapeLock = false
			) else (
				maxOps.startNewShapeLock = true
			)
		)
		Catch() 
	)
        on isChecked return (maxOps.startNewShapeLock)
)
----------------------------------------------------------
macroScript StartNewShape
            category:~STARTNEWSHAPE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STARTNEWSHAPE_TOOLTIP~
            ButtonText:~STARTNEWSHAPE_BUTTONTEXT~ 
(
	on execute do (Try( maxOps.startNewShape() ) Catch() )
)

----------------------------------------------------------
macroScript FreehandSpline 
            category:~FREEHANDSPLINE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~FREEHANDSPLINE_TOOLTIP~ 
            buttontext:~FREEHANDSPLINE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation FreehandSpline
   on isChecked return (mcrUtils.IsCreating FreehandSpline)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCx2juBmd488RQglkRHD33xnz7SpdLlxSqf
-- ufSBug84nZZu/JDsXhdg53iWscTvJfr7zVTaQ8fn2lsBZnE5JmbM68bvJoTRsqrw
-- 8lZklJ/LRrtSugBzXEDh5XqUUXEgu8B5Qvckb1g1mU4cu08dIV7v978qTQWhd/bY
-- dUqQCMcyQ2/Hfbp4GKoH2AneiFEhEHGqTG7WMyidHarRRb41RUZkKMhKxE1li7a6
-- VUEeAQa3Y2Xiwq0jELHcOb+T4Qtfla+WTR3RQ9M5fvVldnautLQCJWHjyGyHV+BM
-- hBZ6DpLpQi9gRXd4rVmly6m7/O6RdHU4ntGsGugdgiuI3EIEhhYQ
-- -----END-SIGNATURE-----